<?php

namespace Modules\Amazon\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Repositories\AmazonFbaInboundShipmentRepository;
use Modules\Amazon\Repositories\AmazonNewFbaInboundPlanRepository;
use Throwable;

class CreateAmazonRefreshFbaInboundPlanItemsJobs implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    private AmazonNewFbaInboundPlanRepository $plans;

    /**
     * Create a new job instance
     *
     * @return void
     */
    public function __construct(protected AmazonIntegrationInstance $amazonIntegrationInstance)
    {
        $this->plans = app(AmazonNewFbaInboundPlanRepository::class);
    }

    /**
     * Execute the job.
     *
     * @throws Throwable
     */
    public function handle(): void
    {
        $planIds = $this->plans->getActiveItemlessPlanIds();

        $planIds->each(function (string $planId) {
            RefreshAmazonFbaInboundPlanItemsJob::dispatch($this->amazonIntegrationInstance, $planId);
        });
    }
}
