<?php

namespace Modules\Amazon\Jobs;

use Exception;
use Modules\Amazon\Actions\CreateAmazonFeed;
use Modules\Amazon\Repositories\AmazonFeedRepository;

class CreateAmazonFeedJob extends AmazonBaseJob
{
    protected AmazonFeedRepository $feedRepository;

    /**
     * Create a new job instance.
     *
     * @return void
     *
     * @throws Exception
     */
    public function __construct(protected int $amazonReportRequestId)
    {
        $this->feedRepository = app(AmazonFeedRepository::class);
    }

    /**
     * Execute the job.
     *
     * @throws Exception
     */
    public function handle(): void
    {
        if ($amazonReportRequest = $this->feedRepository->getFeedRequestFromId($this->amazonReportRequestId)) {
            (new CreateAmazonFeed($amazonReportRequest))->handle();
        }
    }
}
