<?php

namespace Modules\Amazon\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Managers\AmazonInboundManager;
use Modules\Amazon\Repositories\AmazonFbaInboundShipmentRepository;
use Throwable;

class AmazonProcessInboundShipmentCancellationsJob implements ShouldQueue, ShouldBeUnique
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    private AmazonFbaInboundShipmentRepository $amazonFbaInboundShipmentRepository;

    public int $uniqueFor = 60 * 5;

    public function uniqueId(): string
    {
        return $this->amazonIntegrationInstance->id;
    }

    /**
     * Create a new job instance
     *
     * @return void
     */
    public function __construct(protected AmazonIntegrationInstance $amazonIntegrationInstance)
    {
        $this->amazonFbaInboundShipmentRepository = app(AmazonFbaInboundShipmentRepository::class);
    }

    /**
     * Execute the job.
     *
     * @throws Throwable
     */
    public function handle(): void
    {
        (new AmazonInboundManager($this->amazonIntegrationInstance))->processCancellations();

    }
}
