<?php

namespace Modules\Amazon\Jobs;

use Exception;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Managers\AmazonInitialInventoryManager;
use Throwable;

class AmazonInitializeSkuProductsJob implements ShouldBeUnique, ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public int $uniqueFor = 60 * 20;

    public function __construct(private readonly AmazonIntegrationInstance $amazonIntegrationInstance)
    {
    }

    /**
     * Execute the job.
     *
     * @throws Exception
     * @throws Throwable
     */
    public function handle()
    {
        (new AmazonInitialInventoryManager($this->amazonIntegrationInstance))->reconcileAllInitialInventory();
    }
}
