<?php

namespace Modules\Amazon\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Modules\Amazon\Entities\AmazonProduct;

/**
 * Class SalesOrderLineListingAmazonResource.
 *
 * @mixin AmazonProduct|array
 */
class SalesOrderLineListingAmazonResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        if ($this->resource instanceof AmazonProduct) {
            return [
                'id' => $this['id'] ?? $this['_id'],
                'unique_sales_channel_product_id' => $this['seller_sku'],
                'skuAlias' => $this['part_number'],
                'PartNumber' => $this['part_number'],
                'seller-sku' => $this['seller_sku'],
                'item-name' => $this['item_name'],
                'asin1' => $this['asin1'],
                'item-condition' => $this['item_condition'],
                'Model' => $this['model'],
            ];
        } else {
            return [
                'seller-sku' => $this->resource['SellerSKU'],
                'item-name' => $this->resource['Title'],
                'asin1' => $this->resource['ASIN'],
            ];
        }
    }
}
