<?php

namespace Modules\Amazon\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Modules\Amazon\Entities\AmazonReportSettlementTypeMapping;

/**
 * @mixin AmazonReportSettlementTypeMapping
 */
class AmazonReportSettlementTypeMappingResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'financial_code' => $this->financial_code,
            'nominalCode' => $this->whenLoaded('nominalCode', function () {
                $nominalCode = $this->nominalCode;

                return [
                    'id' => $nominalCode->id,
                    'code' => $nominalCode->code,
                    'name' => $nominalCode->name,
                ];
            }),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
