<?php

namespace Modules\Amazon\Http\Resources;

use App\Abstractions\Integrations\SalesChannels\SalesChannelOrderDataTableResource;
use Modules\Amazon\Entities\AmazonOrder;

/**
 * @mixin AmazonOrder
 */
class AmazonOrderResource extends SalesChannelOrderDataTableResource
{
    public function getCustomColumns(): array
    {
        return [
            'integration_instance_id' => $this->inclusive('integration_instance_id', $this->resource->integration_instance_id),
            'sku_sales_order' => $this->resource->salesOrder ? [
                'id' => $this->resource->salesOrder->id,
                'number' => $this->resource->salesOrder->sales_order_number,
            ] : null,
            'BuyerName' => $this->inclusive('BuyerName', decryptValue($this->BuyerName)),
            'items' => $this->whenLoaded('orderItems', function() {
                return $this->orderItems;
            }),
            'json_object' => $this->inclusive('json_object', $this->resource->json_object),
        ];
    }
}
