<?php

namespace Modules\Amazon\Http\Resources;

use App\DataTable\NewDataTableResource;
use Modules\Amazon\Entities\AmazonLedgerSummaryAdjustment;

/**
 * @mixin AmazonLedgerSummaryAdjustment
 */
class AmazonLedgerSummaryAdjustmentResource extends NewDataTableResource
{
    public function getCustomColumns(): array
    {
        return [
            'summary' => $this->whenLoaded('amazonFbaReportInventoryLedgerSummary', function () {
                $fnskuProduct = $this->amazonFbaReportInventoryLedgerSummary->amazonFnskuProduct;
                return array_merge($this->amazonFbaReportInventoryLedgerSummary->only([
                    'asin',
                    'msku',
                    'disposition',
                    'location'
                ]), [
                    'fnsku_product' => $fnskuProduct->only([
                        'id',
                        'fnsku'
                    ]),
                ]);
            }),
            'adjustment' => $this->whenLoaded('inventoryAdjustment', function () {
                $product = $this->inventoryAdjustment->product;
                return array_merge($this->inventoryAdjustment->only([
                    'adjustment_date',
                    'quantity',
                    'notes'
                ]), [
                    'product' => $product->only([
                        'id',
                        'sku'
                    ]),
                ]);
            }),
        ];
    }
}