<?php

namespace Modules\Amazon\Http\Resources;

use App\DataTable\DataTableResource;
use Illuminate\Http\Request;
use Modules\Amazon\Entities\AmazonIntegrationInstance;

/**
 * @mixin AmazonIntegrationInstance
 */
class AmazonIntegrationInstanceResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->inclusive('name', $this->name),
            'connection_settings' => $this->inclusive('connection_settings', $this->connection_settings),
            'integration_settings' => $this->inclusive('integration_settings', $this->integration_settings),
            'sales_channel' => $this->when(! is_null($this->salesChannel), $this->salesChannel),
            'connection_status' => $this->inclusive('connection_status', $this->connection_status),
            'integration_name' => $this->inclusive('integration_name', $this->whenLoaded('integration', function () {
                return $this->integration->name;
            })),
            'store' => $this->inclusive('store', $this->whenLoaded('salesChannel', function () {
                return [
                    'id' => $this->salesChannel->store->id,
                    'name' => $this->salesChannel->store->name,
                ];
            })),
            'created_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
        ];
    }
}
