<?php

namespace Modules\Amazon\Http\Resources;

use App\Abstractions\Integrations\SalesChannels\SalesChannelOrderDataTableResource;
use Modules\Amazon\Entities\AmazonOrder;

/**
 * @mixin AmazonOrder
 */
class AmazonFinancialShipmentEventResource extends SalesChannelOrderDataTableResource
{
    public function getCustomColumns(): array
    {
        return [
            'integration_instance_id' => $this->inclusive('integration_instance_id', $this->resource->integration_instance_id),
            'json_object' => $this->inclusive('json_object', $this->resource->json_object),
        ];
    }
}
