<?php

namespace Modules\Amazon\Http\Resources;

use App\DataTable\DataTableResource;
use Illuminate\Http\Request;
use Modules\Amazon\Entities\AmazonFinancialEventGroup;

/**
 * @mixin AmazonFinancialEventGroup
 */
class AmazonFinancialEventGroupResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this['id'],
            'accounting_status' => $this->inclusive('accounting_status', $this->accounting_status),
            'accounting_transaction_id' => $this->inclusive('accountingTransaction', $this->accountingTransaction?->id),
            'FinancialEventGroupId' => $this->inclusive('FinancialEventGroupId', $this->FinancialEventGroupId),
            'ProcessingStatus' => $this->inclusive('ProcessingStatus', $this->ProcessingStatus),
            'FundTransferStatus' => $this->inclusive('FundTransferStatus', $this->FundTransferStatus),
            'FundTransferDate' => $this->inclusive('FundTransferDate', $this->FundTransferDate),
            'FinancialEventGroupStart' => $this->inclusive('FinancialEventGroupStart', $this->FinancialEventGroupStart),
            'FinancialEventGroupEnd' => $this->inclusive('FinancialEventGroupEnd', $this->FinancialEventGroupEnd),
            'ConvertedTotalCurrencyAmount' => $this->inclusive('ConvertedTotalCurrencyAmount', $this->ConvertedTotalCurrencyAmount),
            'ConvertedTotalCurrencyCode' => $this->inclusive('ConvertedTotalCurrencyCode', $this->ConvertedTotalCurrencyCode),
            'OriginalTotalCurrencyAmount' => $this->inclusive('OriginalTotalCurrencyAmount', $this->OriginalTotalCurrencyAmount),
            'OriginalTotalCurrencyCode' => $this->inclusive('OriginalTotalCurrencyCode', $this->OriginalTotalCurrencyCode),
            'TraceId' => $this->inclusive('TraceId', $this->TraceId),
            'AccountTail' => $this->inclusive('AccountTail', $this->AccountTail),
            'BeginningBalanceCurrencyAmount' => $this->inclusive('BeginningBalanceCurrencyAmount', $this->BeginningBalanceCurrencyAmount),
            'BeginningBalanceCurrencyCode' => $this->inclusive('BeginningBalanceCurrencyCode', $this->BeginningBalanceCurrencyCode),
            'created_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
        ];
    }
}
