<?php

namespace Modules\Amazon\Http\Resources;

use App\DataTable\DataTableResource;
use Illuminate\Http\Request;
use Modules\Amazon\Entities\AmazonFbaReportShipment;

/**
 * @mixin AmazonFbaReportShipment
 */
class AmazonFbaReportShipmentResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'amazon_order_id' => $this->inclusive('amazon_order_id', $this->amazon_order_id),
            'merchant_order_id' => $this->inclusive('merchant_order_id', $this->merchant_order_id),
            'shipment_id' => $this->inclusive('shipment_id', $this->shipment_id),
            'shipment_item_id' => $this->inclusive('shipment_item_id', $this->shipment_item_id),
            'amazon_order_item_id' => $this->inclusive('amazon_order_item_id', $this->amazon_order_item_id),
            'merchant_order_item_id' => $this->inclusive('merchant_order_item_id', $this->merchant_order_item_id),
            'purchase_date' => $this->inclusive('purchase_date', $this->purchase_date),
            'payments_date' => $this->inclusive('payments_date', $this->payments_date),
            'shipment_date' => $this->inclusive('shipment_date', $this->shipment_date),
            'reporting_date' => $this->inclusive('reporting_date', $this->reporting_date),
            'event_datetime' => $this->inclusive('event_datetime', $this->event_datetime),
            'buyer_name' => $this->inclusive('buyer_name', $this->buyer_name),
            'buyer_phone_number' => $this->inclusive('buyer_phone_number', $this->buyer_phone_number),
            'sku' => $this->inclusive('sku', $this->sku),
            'product_name' => $this->inclusive('product_name', $this->product_name),
            'quantity_shipped' => $this->inclusive('quantity_shipped', $this->quantity_shipped),
            'currency' => $this->inclusive('currency', $this->currency),
            'item_price' => $this->inclusive('item_price', $this->item_price),
            'item_tax' => $this->inclusive('item_tax', $this->item_tax),
            'shipping_price' => $this->inclusive('shipping_price', $this->shipping_price),
            'shipping_tax' => $this->inclusive('shipping_tax', $this->shipping_tax),
            'gift_wrap_price' => $this->inclusive('gift_wrap_price', $this->gift_wrap_price),
            'gift_wrap_tax' => $this->inclusive('gift_wrap_tax', $this->gift_wrap_tax),
            'ship_service_level' => $this->inclusive('ship_service_level', $this->ship_service_level),
            'recipient_name' => $this->inclusive('recipient_name', $this->recipient_name),
            'ship_address_1' => $this->inclusive('ship_address_1', $this->ship_address_1),
            'ship_address_2' => $this->inclusive('ship_address_2', $this->ship_address_2),
            'ship_address_3' => $this->inclusive('ship_address_3', $this->ship_address_3),
            'ship_city' => $this->inclusive('ship_city', $this->ship_city),
            'ship_state' => $this->inclusive('ship_state', $this->ship_state),
            'ship_postal_code' => $this->inclusive('ship_postal_code', $this->ship_postal_code),
            'ship_country' => $this->inclusive('ship_country', $this->ship_country),
            'ship_phone_number' => $this->inclusive('ship_phone_number', $this->ship_phone_number),
            'bill_address_1' => $this->inclusive('bill_address_1', $this->bill_address_1),
            'bill_address_2' => $this->inclusive('bill_address_2', $this->bill_address_2),
            'bill_address_3' => $this->inclusive('bill_address_3', $this->bill_address_3),
            'bill_city' => $this->inclusive('bill_city', $this->bill_city),
            'bill_state' => $this->inclusive('bill_state', $this->bill_state),
            'bill_postal_code' => $this->inclusive('bill_postal_code', $this->bill_postal_code),
            'bill_country' => $this->inclusive('bill_country', $this->bill_country),
            'item_promotion_discount' => $this->inclusive('item_promotion_discount', $this->item_promotion_discount),
            'ship_promotion_discount' => $this->inclusive('ship_promotion_discount', $this->ship_promotion_discount),
            'carrier' => $this->inclusive('carrier', $this->carrier),
            'tracking_number' => $this->inclusive('tracking_number', $this->tracking_number),
            'estimated_arrival_date' => $this->inclusive('estimated_arrival_date', $this->estimated_arrival_date),
            'fulfillment_center_id' => $this->inclusive('fulfillment_center_id', $this->fulfillment_center_id),
            'fulfillment_channel' => $this->inclusive('fulfillment_channel', $this->fulfillment_channel),
            'sales_channel' => $this->inclusive('sales_channel', $this->sales_channel),
            'created_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
            'ledger_id' => $this->ledger?->id,
        ];
    }
}
