<?php

namespace Modules\Amazon\Http\Resources;

use App\DataTable\DataTableResource;
use Illuminate\Http\Request;
use Modules\Amazon\Entities\AmazonFbaReportRemovalShipment;

/**
 * @mixin AmazonFbaReportRemovalShipment
 */
class AmazonFbaReportRemovalShipmentResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'event_datetime' => $this->inclusive('event_datetime', $this->event_datetime),
            'request_date' => $this->inclusive('request_date', $this->request_date),
            'shipment_date' => $this->inclusive('shipment_date', $this->shipment_date),
            'order_id' => $this->inclusive('order_id', $this->order_id),
            'sku' => $this->inclusive('sku', $this->sku),
            'fnsku' => $this->inclusive('fnsku', $this->fnsku),
            'disposition' => $this->inclusive('disposition', $this->disposition),
            'shipped_quantity' => $this->inclusive('shipped_quantity', $this->shipped_quantity),
            'carrier' => $this->inclusive('carrier', $this->carrier),
            'tracking_number' => $this->inclusive('tracking_number', $this->tracking_number),
            'removal_order_type' => $this->inclusive('removal_order_type', $this->removal_order_type),
            'created_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
            'ledger_id' => $this->ledger?->id,
        ];
    }
}
