<?php

namespace Modules\Amazon\Http\Resources;

use App\DataTable\DataTableResource;
use Illuminate\Http\Request;
use Modules\Amazon\Entities\AmazonFbaReportInventory;

/**
 * @mixin AmazonFbaReportInventory
 */
class AmazonFbaReportInventoryResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this['id'],
            'sku' => $this->inclusive('sku', function () {
                return [
                    'value' => $this->sku,
                    'amazon_product_id' => $this->amazonProduct?->id,
                ];
            }),
            /*'sku'                => $this->inclusive('sku', $this->whenLoaded('amazonProduct', function () {
                return [
                    'name' => $this->sku,
                    'link' => $this->amazonProduct->product->id,
                ];
            })),*/
            /*'amazon_product' => $this->inclusive('amazon_product', $this->whenLoaded('amazonProduct', function () {
                return [
                    'name' => $this->amazonProduct?->item_name,
                    'link' => $this->amazonProduct?->id,
                ];
            })),*/
            'fnsku' => $this->inclusive('fnsku', $this->fnsku),
            'product_name' => $this->inclusive('product_name', $this->product_name),
            'condition' => $this->inclusive('condition', $this->condition),
            'your_price' => $this->inclusive('your_price', $this->your_price),
            'mfn_listing_exists' => $this->inclusive('mfn_listing_exists', $this->mfn_listing_exists),
            'mfn_fulfillable_quantity' => $this->inclusive('mfn_fulfillable_quantity', $this->mfn_fulfillable_quantity),
            'afn_listing_exists' => $this->inclusive('afn_listing_exists', $this->afn_listing_exists),
            'afn_warehouse_quantity' => $this->inclusive('afn_warehouse_quantity', $this->afn_warehouse_quantity),
            'afn_fulfillable_quantity' => $this->inclusive('afn_fulfillable_quantity', $this->afn_fulfillable_quantity),
            'afn_unsellable_quantity' => $this->inclusive('afn_unsellable_quantity', $this->afn_unsellable_quantity),
            'afn_reserved_quantity' => $this->inclusive('afn_reserved_quantity', $this->afn_reserved_quantity),
            'afn_total_quantity' => $this->inclusive('afn_total_quantity', $this->afn_total_quantity),
            'per_unit_volume' => $this->inclusive('per_unit_volume', $this->per_unit_volume),
            'afn_inbound_working_quantity' => $this->inclusive('afn_inbound_working_quantity', $this->afn_inbound_working_quantity),
            'afn_inbound_shipped_quantity' => $this->inclusive('afn_inbound_shipped_quantity', $this->afn_inbound_shipped_quantity),
            'afn_inbound_receiving_quantity' => $this->inclusive('afn_inbound_receiving_quantity', $this->afn_inbound_receiving_quantity),
            'afn_researching_quantity' => $this->inclusive('afn_researching_quantity', $this->afn_researching_quantity),
            'afn_reserved_future_supply' => $this->inclusive('afn_reserved_future_supply', $this->afn_reserved_future_supply),
            'afn_future_supply_buyable' => $this->inclusive('afn_future_supply_buyable', $this->afn_future_supply_buyable),
            'created_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
        ];
    }
}
