<?php

namespace Modules\Amazon\Http\Resources;

use App\DataTable\DataTableResource;
use Illuminate\Http\Request;
use Modules\Amazon\Entities\AmazonFbaReportInventoryLedger;
use Modules\Amazon\Entities\AmazonLedgerDetail;

/**
 * @mixin AmazonFbaReportInventoryLedger
 */
class AmazonFbaReportInventoryLedgerResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this['id'],
            'date' => $this->inclusive('date', $this->date),
            'event_type' => $this->inclusive('event_type', $this->event_type),
            'details' => $this->inclusive('details', $this->whenLoaded('ledgerDetails', function () {
                return $this->ledgerDetails->map(function (AmazonLedgerDetail $ledgerDetail) {
                    $detail = $ledgerDetail->detail;
                    return [
                        'id' => $ledgerDetail->detail_id,
                        'type' => $ledgerDetail->detail_type,
                        'quantity' => $detail ? $detail->{$detail::getQuantityField()} : 0,
                    ];
                });
            })),
            'sku_link' => $this->inclusive('sku_link', $this->whenLoaded('skuLink', function () {
                return [
                    'id' => $this->skuLink?->getDrawer()->id,
                    'type' => $this->skuLink?->getDrawer() ? get_class($this->skuLink?->getDrawer()) : null,
                    'displayType' => $this->skuLink?->getDrawer() ? convertFQNToFriendlyName(get_class($this->skuLink?->getDrawer())) : null,
                    'name' => $this->skuLink?->getDrawer()?->getReference() ?? null,
                ];
            })),
            'amazon_product' => $this->inclusive('msku', $this->whenLoaded('amazonProduct', function () {
                return [
                    'id' => $this->amazonProduct?->id,
                ];
            })),
            'sku_reference' => $this->inclusive('sku_reference', $this->whenLoaded('skuLink', $this->skuLink?->getDrawer()->getReference())),
            'errorLog' => $this->inclusive('errorLog', $this->errorLog),
            'last_reconciliation_attempted_at' => $this->inclusive('last_reconciliation_attempted_at', $this->last_reconciliation_attempted_at),
            'reconciled_at' => $this->inclusive('reconciled_at', $this->reconciled_at),
            'msku' => $this->inclusive('msku', $this->msku),
            'fnsku' => $this->inclusive('fnsku', $this->fnsku),
            'fnsku_product' => $this->inclusive('fnsku_product', $this->whenLoaded('amazonFnskuProduct', function () {
                return [
                    'id' => $this->amazonFnskuProduct?->id,
                ];
            })),
            'asin' => $this->inclusive('asin', $this->asin),
            'quantity' => $this->inclusive('quantity', $this->quantity),
            'reference_id' => $this->inclusive('reference_id', $this->reference_id),
            'fulfillment_center' => $this->inclusive('fulfillment_center', $this->fulfillment_center),
            'disposition' => $this->inclusive('disposition', $this->disposition),
            'country' => $this->inclusive('country', $this->country),
            'reconciled_quantity' => $this->inclusive('reconciled_quantity', $this->reconciled_quantity),
            'unreconciled_quantity' => $this->inclusive('unreconciled_quantity', $this->unreconciled_quantity),
            'created_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
        ];
    }
}
