<?php

namespace Modules\Amazon\Http\Resources;

use App\DataTable\DataTableResource;
use Illuminate\Http\Request;
use Modules\Amazon\Entities\AmazonFbaReportCustomerReturn;

/**
 * @mixin AmazonFbaReportCustomerReturn
 */
class AmazonFbaReportCustomerReturnResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'event_datetime' => $this->inclusive('event_datetime', $this->event_datetime),
            'order_id' => $this->inclusive('order_id', $this->order_id),
            'sku' => $this->inclusive('sku', $this->sku),
            'asin' => $this->inclusive('asin', $this->asin),
            'fnsku' => $this->inclusive('fnsku', $this->fnsku),
            'amazon_product' => $this->inclusive('sku', $this->whenLoaded('amazonProduct', function () {
                return [
                    'id' => $this->amazonProduct?->id,
                ];
            })),
            'product_name' => $this->inclusive('product_name', $this->product_name),
            'quantity' => $this->inclusive('quantity', $this->quantity),
            'fulfillment_center_id' => $this->inclusive('fulfillment_center_id', $this->fulfillment_center_id),
            'detailed_disposition' => $this->inclusive('detailed_disposition', $this->detailed_disposition),
            'reason' => $this->inclusive('reason', $this->reason),
            'status' => $this->inclusive('status', $this->status),
            'license_plate_number' => $this->inclusive('license_plate_number', $this->license_plate_number),
            'customer_comments' => $this->inclusive('customer_comments', $this->customer_comments),
            'created_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
            'ledger_id' => $this->ledger?->id,
        ];
    }
}
