<?php

namespace Modules\Amazon\Http\Resources;

use App\DataTable\NewDataTableResource;
use Modules\Amazon\Entities\AmazonFbaInitialInventory;

/**
 * @mixin AmazonFbaInitialInventory
 */
class AmazonFbaInitialInventoryResource extends NewDataTableResource
{
    public function getCustomColumns(): array
    {
        return [
            'fnskuProduct' => $this->inclusive('fnskuProduct', $this->whenLoaded(
                'amazonFnskuProduct',
                $this->amazonFnskuProduct->only(['id', 'reconciled_quantity'])
            )),
        ];
    }
}
