<?php

namespace Modules\Amazon\Http\Resources;

use App\DataTable\DataTableResource;
use Illuminate\Http\Request;
use Modules\Amazon\Entities\AmazonFbaInboundShipment;

/**
 * @mixin AmazonFbaInboundShipment
 */
class AmazonFbaInboundShipmentResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        $skuLink = $this->sku_link;
        if($skuLink) {
            $skuLinkName = $skuLink->{$skuLink::getNumberFieldName()};
        }
        else {
            $skuLinkName = null;
        }
        return [
            'id' => $this->id,
            'ShipmentId' => $this->inclusive('ShipmentId', $this->ShipmentId),
            'ShipmentName' => $this->inclusive('ShipmentName', $this->ShipmentName),
            'ShipFromName' => $this->inclusive('ShipFromName', $this->ShipFromName),
            'DestinationFulfillmentCenterId' => $this->inclusive('DestinationFulfillmentCenterId', $this->DestinationFulfillmentCenterId),
            'ShipmentStatus' => $this->inclusive('ShipmentStatus', $this->ShipmentStatus),
            'LabelPrepType' => $this->inclusive('LabelPrepType', $this->LabelPrepType),
            'BoxContentsSource' => $this->inclusive('BoxContentsSource', $this->BoxContentsSource),
            'errorLog' => $this->inclusive('errorLog', $this->errorLog),
            'is_before_initial_count' => $this->inclusive('is_before_initial_count', $this->is_before_initial_count),
            'sku_link' => $this->inclusive('sku_link', [
                'id' => $this->sku_link_id,
                'type' => $this->sku_link_type,
                'name' => $skuLinkName,
                'displayType' => convertFQNToFriendlyName($this->sku_link_type),
            ]),
            'ledgers' => $this->whenLoaded('ledgers', function () {
                return $this->ledgers;
            }),
            'created_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
            'items' => $this->inclusive('items', $this->whenLoaded('amazonFbaInboundShipmentItems', function () {
                return AmazonFbaInboundShipmentItemResource::collection($this->amazonFbaInboundShipmentItems);
            })),
        ];
    }
}
