<?php

namespace Modules\Amazon\Http\Requests;

use App\Helpers;
use App\Models\Setting;
use Carbon\Carbon;
use Illuminate\Foundation\Http\FormRequest;

class StoreAmazonIntegrationInstanceRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        $inventoryStartDate = Helpers::dateUtcToLocal(Helpers::setting(Setting::KEY_INVENTORY_START_DATE));
        $before72Hours = Helpers::dateUtcToLocal(Carbon::now()->subHours(72));

        $rules = [
            'integration_id' => 'required|exists:integrations,id',
            'name' => 'required|unique:integration_instances,name',
            'integration_settings' => 'required|array',
            'integration_settings.*' => 'nullable', // this rule to read all options
            'integration_settings.store_id' => 'required|exists:stores,id',
            'integration_settings.auto_create_products' => 'required|boolean',
            'integration_settings.auto_link_products' => 'required|boolean',
            'integration_settings.start_date' => 'required|date|after_or_equal:'.$inventoryStartDate,
            'integration_settings.is_fba_enabled' => 'required|boolean',
            'integration_settings.fba_inventory_tracking_start_date' => 'required_if:integration_settings.is_fba_enabled,true|date|after_or_equal:'.$inventoryStartDate.'|before:'.$before72Hours,
            'integration_settings.proforma_marketplace_cost_percentage' => 'nullable|numeric',
            'integration_settings.proforma_payment_cost_percentage' => 'nullable|numeric',
            'integration_settings.batch_sales_order_invoices' => 'sometimes|boolean',
            'is_automatic_sync_enabled' => 'sometimes|boolean',
        ];

        if ($this->isMethod('PUT')) {
            unset($rules['integration_id']);
            // TODO: Not sure how to handle the unique for updates
            $rules['name'] = 'sometimes';
            $rules['integration_settings'] = 'sometimes|array';
            $rules['integration_settings.*'] = 'nullable';
            $rules['integration_settings.store_id'] = 'sometimes|exists:stores,id';
            $rules['integration_settings.auto_create_products'] = 'sometimes|boolean';
            $rules['integration_settings.auto_link_products'] = 'sometimes|boolean';
            $rules['integration_settings.start_date'] = 'sometimes|date|after_or_equal:'.$inventoryStartDate;
            $rules['integration_settings.is_fba_enabled'] = 'sometimes|boolean';
            $rules['integration_settings.pricing'] = 'sometimes|array';
            $rules['integration_settings.inventory'] = 'sometimes|array';
            $rules['integration_settings.fba_inventory_tracking_start_date'] = 'required_if:integration_settings.is_fba_enabled,true|date|after_or_equal:'.$inventoryStartDate;
            $rules['integration_settings.batch_sales_order_invoices'] = 'sometimes|boolean';
            $rules['is_automatic_sync_enabled'] = 'sometimes|boolean';
        }

        return $rules;
    }
}
