<?php

namespace Modules\Amazon\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class MapAmazonFinancialEventTypeNominalCodeRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        $rules = [
            'mappings' => [
                'required',
                'array',
            ],
            'mappings.*.nominal_code_id' => 'required|exists:nominal_codes,id',
            'mappings.*.id' => 'required|exists:amazon_financial_event_type_nominal_code_mappings,id',
        ];

        return $rules;
    }
}
