<?php

namespace Modules\Amazon\Http\Requests\AmazonProduct;

use App\Importers\Parsers\FieldParserFactory;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class CreateSkuProductRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'filters' => 'nullable',
            'ids' => [
                Rule::requiredIf(function () {
                    return ! $this->get('create_all_products') && ! $this->get('filters');
                }),
                'array',
                'exists:amazon_products,id',
            ],
            'create_all_products' => 'required|boolean',
            'mapping.*.listing_field' => 'required',
            'mapping.*.sku_field' => 'required',
            'mapping.*.parsers' => 'nullable|array',
            'mapping.*.parsers.*.rule' => 'required|in:'.implode(',', FieldParserFactory::SUPPORTED_PARSERS),
            'mapping.*.parsers.*.args' => 'required',
            'initial_mapping' => 'nullable',
        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }
}
