<?php

namespace Modules\Amazon\Http\Controllers\Concerns;

use App\DataTable\DataTable;
use App\Exceptions\ExportingEmptyDataException;
use App\Response;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\AnonymousResourceCollection;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Symfony\Component\HttpFoundation\BinaryFileResponse;

trait AmazonExportableControllerTrait
{
    use DataTable;

    /**
     * @throws ExportingEmptyDataException
     */
    public function exportForIntegration(Request $request, AmazonIntegrationInstance $integrationInstance): BinaryFileResponse|Response|RedirectResponse
    {
        return $this->abstractExportForIntegration($request, $integrationInstance);
    }
}