<?php

namespace Modules\Amazon\Http\Controllers;

use App\Abstractions\Integrations\SalesChannels\AbstractSalesChannelFinancialEventController;
use App\Exceptions\ExportingEmptyDataException;
use App\Response;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Modules\Amazon\Entities\AmazonFinancialShipmentEvent;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Http\Resources\AmazonFinancialShipmentEventResource;
use Modules\Amazon\Jobs\RefreshAmazonOrdersJob;
use Symfony\Component\HttpFoundation\BinaryFileResponse;

class AmazonFinancialShipmentEventController extends AbstractSalesChannelFinancialEventController
{
    protected function getModel(): string
    {
        return AmazonFinancialShipmentEvent::class;
    }

    protected function getResource(): string
    {
        return AmazonFinancialShipmentEventResource::class;
    }

    // Typehint $integrationInstance with the integration implementation
    public function indexForIntegration(Request $request, AmazonIntegrationInstance $integrationInstance)
    {
        return parent::abstractIndexForIntegration($request, $integrationInstance);
    }

    public function show(AmazonIntegrationInstance $integrationInstance, AmazonFinancialShipmentEvent $financialEvent): Response
    {
        return parent::abstractShow($financialEvent);
    }

    public function refresh(AmazonIntegrationInstance $integrationInstance): Response
    {
        return $this->abstractRefresh(new RefreshAmazonOrdersJob($integrationInstance, app($this->getModel())->refreshAdt()));
    }

    /**
     * @throws ExportingEmptyDataException
     */
    protected function exportForIntegration(Request $request, AmazonIntegrationInstance $integrationInstance): BinaryFileResponse|Response|RedirectResponse
    {
        return $this->abstractExportForIntegration($request, $integrationInstance);
    }
}
