<?php

namespace Modules\Amazon\Http\Controllers;

use App\DataTable\DataTableResource;
use App\Response;
use Modules\Amazon\Entities\AmazonFbaReportShipment;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Http\Controllers\Concerns\AmazonExportableControllerTrait;
use Modules\Amazon\Http\Resources\AmazonFbaReportShipmentResource;
use Modules\Amazon\Repositories\AmazonReportRepository;

class AmazonFbaReportShipmentController extends AbstractAmazonDataTableController
{
    use AmazonExportableControllerTrait;

    private AmazonReportRepository $amazonReportRepository;

    public function __construct()
    {
        $this->amazonReportRepository = app(AmazonReportRepository::class);
        parent::__construct();
    }

    public function show(AmazonIntegrationInstance $integrationInstance, AmazonFbaReportShipment $shipment): ?Response
    {
        return $this->response->addData(AmazonFbaReportShipmentResource::make($shipment));
    }

    protected function getModel(): string
    {
        return AmazonFbaReportShipment::class;
    }

    protected function getResource(): DataTableResource|string
    {
        return AmazonFbaReportShipmentResource::class;
    }
}
