<?php

namespace Modules\Amazon\Http\Controllers;

use App\Response;
use Modules\Amazon\Entities\AmazonFbaReportRestock;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Http\Controllers\Concerns\AmazonExportableControllerTrait;
use Modules\Amazon\Http\Resources\AmazonFbaReportRestockResource;

class AmazonFbaReportRestockController extends AbstractAmazonDataTableController
{
    use AmazonExportableControllerTrait;

    public function show(AmazonIntegrationInstance $integrationInstance, AmazonFbaReportRestock $restock): ?Response
    {
        return $this->response->addData(AmazonFbaReportRestockResource::make($restock));
    }

    protected function getModel(): string
    {
        return AmazonFbaReportRestock::class;
    }

    protected function getResource(): string
    {
        return AmazonFbaReportRestockResource::class;
    }
}
