<?php

namespace Modules\Amazon\Http\Controllers;

use App\DataTable\DataTableResource;
use App\Response;
use Modules\Amazon\Entities\AmazonFbaReportRemovalShipment;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Http\Controllers\Concerns\AmazonExportableControllerTrait;
use Modules\Amazon\Http\Resources\AmazonFbaReportRemovalShipmentResource;
use Modules\Amazon\Repositories\AmazonReportRepository;

class AmazonFbaReportRemovalShipmentController extends AbstractAmazonDataTableController
{
    use AmazonExportableControllerTrait;

    private AmazonReportRepository $amazonReportRepository;

    public function __construct()
    {
        $this->amazonReportRepository = app(AmazonReportRepository::class);
        parent::__construct();
    }

    public function show(AmazonIntegrationInstance $integrationInstance, AmazonFbaReportRemovalShipment $removalShipment): ?Response
    {
        return $this->response->addData(AmazonFbaReportRemovalShipmentResource::make($removalShipment));
    }

    protected function getModel(): string
    {
        return AmazonFbaReportRemovalShipment::class;
    }

    protected function getResource(): DataTableResource|string
    {
        return AmazonFbaReportRemovalShipmentResource::class;
    }
}
