<?php

namespace Modules\Amazon\Http\Controllers;

use App\Response;
use Modules\Amazon\Entities\AmazonFbaReportInventory;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Http\Resources\AmazonFbaReportInventoryResource;

class AmazonFbaReportInventoryController extends AbstractAmazonDataTableController
{
    public function show(AmazonIntegrationInstance $integrationInstance, AmazonFbaReportInventory $amazonFbaReportInventory): Response
    {
        return $this->response->addData(AmazonFbaReportInventoryResource::make($amazonFbaReportInventory));
    }

    protected function getModel(): string
    {
        return AmazonFbaReportInventory::class;
    }

    protected function getResource(): string
    {
        return AmazonFbaReportInventoryResource::class;
    }
}
