<?php

namespace Modules\Amazon\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Response;
use Illuminate\Http\Request;
use Modules\Amazon\Data\AmazonFbaInboundShipFromMappingData;
use Modules\Amazon\Data\UpdateAmazonFbaInboundShipFromMappingData;
use Modules\Amazon\Entities\AmazonFbaInboundShipFromMapping;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Http\Resources\AmazonFbaInboundShipFromMappingResource;
use Modules\Amazon\Repositories\AmazonFbaInboundShipFromMappingRepository;

class AmazonFbaInboundShipFromMappingController extends Controller
{
    public function __construct(
        private readonly AmazonFbaInboundShipFromMappingRepository $mappings,
    )
    {
        parent::__construct();
    }

    public function index()
    {
        return AmazonFbaInboundShipFromMappingResource::collection($this->mappings->getMappings());
    }

    public function updateMappings(Request $request, AmazonIntegrationInstance $integrationInstance): Response
    {
        $data = UpdateAmazonFbaInboundShipFromMappingData::collection($request->toArray());
        batch()->update(new AmazonFbaInboundShipFromMapping(), $data->toArray(), 'id');
        return $this->response->success(message: 'Amazon FBA Ship From Mapping updated successfully.');
    }
}
