<?php

namespace Modules\Amazon\Http\Controllers;

use App\Abstractions\AbstractOauthAuthenticationCallbackCallbackController;
use App\Abstractions\Integrations\AbstractIntegrationInstanceRepository;
use App\Abstractions\Integrations\IntegrationClientInterface;
use App\Abstractions\Integrations\IntegrationInstanceInterface;
use App\Response;
use Exception;
use Illuminate\Http\RedirectResponse;
use Modules\Amazon\ApiDataTransferObjects\AmazonGetOrdersAdt;
use Modules\Amazon\Data\AmazonAuthorizationResponseData;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Jobs\RefreshAmazonFbaInboundShipmentsJob;
use Modules\Amazon\Jobs\RefreshAmazonFinancialEventGroupsJob;
use Modules\Amazon\Jobs\RefreshAmazonOrdersJob;
use Modules\Amazon\Managers\AmazonIntegrationInstanceManager;
use Modules\Amazon\Repositories\AmazonIntegrationInstanceRepository;
use Modules\Amazon\Services\AmazonClient;
use Throwable;

class AmazonAuthenticationController extends AbstractOauthAuthenticationCallbackCallbackController
{
    public function getIntegrationInstanceRepository(): AbstractIntegrationInstanceRepository
    {
        return app(AmazonIntegrationInstanceRepository::class);
    }

    /**
     * @throws Exception
     */
    public function getClient(IntegrationInstanceInterface $integrationInstance): IntegrationClientInterface
    {
        return new AmazonClient($integrationInstance);
    }

    public function getStateParameterName(): string
    {
        return 'state';
    }

    /**
     * @throws Exception
     */
    public function getRedirectUrl(AmazonIntegrationInstance $integrationInstance): Response
    {
        return $this->response->addData((new AmazonClient($integrationInstance))->getRedirectUrl());
    }

    /**
     * @throws Exception
     * @throws Throwable
     */
    public function callback(AmazonAuthorizationResponseData $data): RedirectResponse
    {
        /** @var AmazonIntegrationInstance $integrationInstance */
        $integrationInstance = parent::abstractCallback($data);

        $manager = new AmazonIntegrationInstanceManager($integrationInstance);

        $manager->getMarketplaceParticipations();
        $manager->requestInitialReports();
        $manager->processAmazonFbaStateChange();
        dispatch(new RefreshAmazonFinancialEventGroupsJob($integrationInstance))->onQueue('sales-channels');
        dispatch(new RefreshAmazonOrdersJob($integrationInstance, new AmazonGetOrdersAdt()))->onQueue('sales-channels');

        return redirect("/integrations/amazon-us/{$integrationInstance->id}/dashboard");
    }
}
