<?php

namespace Modules\Amazon\Enums\Entities;

use ArchTech\Enums\InvokableCases;

/**
 * @method static FATAL()
 */
enum ReportProcessingStatusEnum: string
{
    use InvokableCases;

    case CANCELLED = 'CANCELLED';
    case DONE = 'DONE';
    case FATAL = 'FATAL';
    case IN_PROGRESS = 'IN_PROGRESS';
    case IN_QUEUE = 'IN_QUEUE';

    // A SKU.io case used for reports that need to retry due to the original date for that date range not reflecting the current data for that date range (Amazon bug)
    case RETRY = 'RETRY';

    const NON_FATAL_STATUSES = [
        self::DONE,
        self::IN_PROGRESS,
        self::IN_QUEUE,
    ];

    const COMPLETE_STATUSES = [
        self::CANCELLED,
        self::DONE,
        self::FATAL,
        self::RETRY
    ];
}
