<?php

namespace Modules\Amazon\Enums\Entities;

use ArchTech\Enums\InvokableCases;
use ArchTech\Enums\Values;

enum OrderStatusEnum: string
{
    use InvokableCases;
    use Values;

    case STATUS_PENDING_AVAILABILITY = 'PendingAvailability';
    case STATUS_PENDING = 'Pending';
    case STATUS_UNSHIPPED = 'Unshipped';
    case STATUS_PARTIALLY_SHIPPED = 'PartiallyShipped';
    case STATUS_SHIPPED = 'Shipped';
    case STATUS_INVOICE_UNCONFIRMED = 'InvoiceUnconfirmed';
    case STATUS_CANCELED = 'Canceled';
    case STATUS_UNFULFILLABLE = 'Unfulfillable';

    public const STATUSES_ACTIVE = [
        self::STATUS_UNSHIPPED,
        self::STATUS_PARTIALLY_SHIPPED,
        self::STATUS_SHIPPED,
    ];
}
