<?php

namespace Modules\Amazon\Enums\Entities;

use App\Models\WarehouseTransfer;
use ArchTech\Enums\InvokableCases;
use ArchTech\Enums\Values;

enum FbaInboundPlanStatusEnum: string
{
    use InvokableCases, Values;

    case ACTIVE = 'ACTIVE';
    case VOIDED = 'VOIDED';
    case SHIPPED = 'SHIPPED';
    case ERRORED = 'ERRORED';

    public const STATUSES_ACTIVE = [
        'ACTIVE',
        'SHIPPED',
    ];

    public const WAREHOUSE_TRANSFER_STATUS_MAPPINGS = [
        'ACTIVE' => WarehouseTransfer::TRANSFER_STATUS_DRAFT,
        'SHIPPED' => WarehouseTransfer::TRANSFER_STATUS_OPEN,
    ];

    public const ALLOWED_SHIPMENT_STATUS_MAPPINGS = [
        'ACTIVE' => WarehouseTransfer::TRANSFER_SHIPMENT_STATUS_UNSHIPPED,
        'SHIPPED' => WarehouseTransfer::TRANSFER_SHIPMENT_STATUS_SHIPPED,
    ];

    public const WAREHOUSE_TRANSFER_RECEIPT_STATUS_MAPPINGS = [
        'ACTIVE' => WarehouseTransfer::TRANSFER_RECEIPT_STATUS_UNRECEIVED,
        'SHIPPED' => WarehouseTransfer::TRANSFER_RECEIPT_STATUS_UNRECEIVED,
    ];
}
