<?php

namespace Modules\Amazon\Enums\Entities;

use ArchTech\Enums\InvokableCases;
use ArchTech\Enums\Values;

enum AmazonLedgerDispositionEnum: string
{
    use InvokableCases,
        Values;

    case SELLABLE = 'SELLABLE';
    case DEFECTIVE = 'DEFECTIVE';
    case CUSTOMER_DAMAGED = 'CUSTOMER_DAMAGED';
    case DISTRIBUTOR_DAMAGED = 'DISTRIBUTOR_DAMAGED';
    case WAREHOUSE_DAMAGED = 'WAREHOUSE_DAMAGED';
    case CARRIER_DAMAGED = 'CARRIER_DAMAGED';
    case EXPIRED = 'EXPIRED';

    const VENDOR_RETURN_DISPOSITIONS = [
        'SELLABLE' => AmazonVendorReturnDispositionEnum::SELLABLE,
        'DEFECTIVE' => AmazonVendorReturnDispositionEnum::UNSELLABLE,
        'CUSTOMER_DAMAGED' => AmazonVendorReturnDispositionEnum::UNSELLABLE,
        'DISTRIBUTOR_DAMAGED' => AmazonVendorReturnDispositionEnum::UNSELLABLE,
        'WAREHOUSE_DAMAGED' => AmazonVendorReturnDispositionEnum::UNSELLABLE,
        'CARRIER_DAMAGED' => AmazonVendorReturnDispositionEnum::UNSELLABLE,
        'EXPIRED' => AmazonVendorReturnDispositionEnum::UNSELLABLE,
    ];

    const CUSTOMER_RETURN_DISPOSITIONS = [
        'SELLABLE' => AmazonCustomerReturnDispositionEnum::SELLABLE,
        'DEFECTIVE' => AmazonCustomerReturnDispositionEnum::DEFECTIVE,
        'CUSTOMER_DAMAGED' => AmazonCustomerReturnDispositionEnum::CUSTOMER_DAMAGED,
        'DISTRIBUTOR_DAMAGED' => AmazonCustomerReturnDispositionEnum::DAMAGED,
        'WAREHOUSE_DAMAGED' => AmazonCustomerReturnDispositionEnum::DAMAGED,
        'CARRIER_DAMAGED' => AmazonCustomerReturnDispositionEnum::CARRIER_DAMAGED,
        'EXPIRED' => AmazonCustomerReturnDispositionEnum::EXPIRED,
    ];
}
