<?php

namespace Modules\Amazon\Enums\Entities;

use ArchTech\Enums\InvokableCases;
use ArchTech\Enums\Values;

enum AmazonFeedTypeEnum: string
{
    use InvokableCases,
        Values;

    // From https://developer-docs.amazon.com/sp-api/docs/feed-type-values
    case INVENTORY = 'POST_INVENTORY_AVAILABILITY_DATA';
    case PRICING = 'POST_PRODUCT_PRICING_DATA';
    // case INVENTORY_PRICING = 'POST_INVENTORY_AVAILABILITY_DATA';
    case ORDER_ACKNOWLEDGEMENT = 'POST_ORDER_ACKNOWLEDGEMENT_DATA';
    case ORDER_FULFILLMENT = 'POST_ORDER_FULFILLMENT_DATA';
    /*case MULTI_CHANNEL_FULFILLMENT = 'POST_FLAT_FILE_FULFILLMENT_ORDER_REQUEST_DATA';
    case MULTI_CHANNEL_FULFILLMENT_CANCEL = 'POST_FLAT_FILE_FULFILLMENT_ORDER_CANCELLATION_REQUEST_DATA';
    case FBA_INBOUND_CARTON_CONTENTS = 'POST_FBA_INBOUND_CARTON_CONTENTS';
    case FBA_INBOUND_PLAN_CREATE = 'POST_FLAT_FILE_FBA_CREATE_INBOUND_PLAN';
    case FBA_INBOUND_PLAN_UPDATE = 'POST_FLAT_FILE_FBA_UPDATE_INBOUND_PLAN';
    case FBA_REMOVAL = 'POST_FLAT_FILE_FBA_CREATE_REMOVAL';

    const MULTI_CHANNEL_FEEDS = [
        self::MULTI_CHANNEL_FULFILLMENT,
        self::MULTI_CHANNEL_FULFILLMENT_CANCEL,
    ];*/
}
