<?php

namespace Modules\Amazon\Entities;

use App\Models\NominalCode;
use Awobaz\Compoships\Compoships;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Carbon;

/**
 * @property int $id
 * @property int $integration_instance_id
 * @property int $nominal_code_id
 * @property string $transaction_type
 * @property string $amount_type
 * @property string $amount_description
 * @property-read  string $financial_code
 * @property-read string $type
 * @property-read AmazonIntegrationInstance $integrationInstance
 * @property-read NominalCode $nominalCode
 * @property Carbon $created_at
 * @property ?Carbon $updated_at
 */
class AmazonReportSettlementTypeMapping extends Model
{
    use Compoships;
    use HasFactory;

    protected $guarded = [];

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function integrationInstance(): BelongsTo
    {
        return $this->belongsTo(AmazonIntegrationInstance::class);
    }

    public function nominalCode(): BelongsTo
    {
        return $this->belongsTo(NominalCode::class);
    }

    /*
    |--------------------------------------------------------------------------
    | Accessors & Mutators
    |--------------------------------------------------------------------------
    */

    public function type(): Attribute
    {
        return Attribute::get(
            fn ($value) => implode('->', [
                $this->transaction_type,
                $this->amount_type,
                $this->amount_description,
            ]),
        );
    }
}
