<?php

namespace Modules\Amazon\Entities;

use App\Models\User;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Modules\Amazon\Database\Factories\AmazonReportRequestFactory;
use Modules\Amazon\Enums\Entities\AmazonReportTypeEnum;

/**
 * Class AmazonReportRequest.
 *
 * @property int $id
 * @property int $integration_instance_id
 * @property AmazonReportTypeEnum $reportType
 * @property Carbon $dataStartTime
 * @property Carbon $dataEndTime
 * @property array $options
 * @property array $marketplaceIds
 * @property int $requested_by_user_id
 * @property-read AmazonIntegrationInstance $integrationInstance
 * @property-read User $requestedByUser
 * @property Carbon $created_at
 * @property Carbon $updated_at
 *
 * @mixin IdeHelperAmazonReportRequest
 */
class AmazonReportRequest extends Model
{
    use HasFactory;

    protected $casts = [
        'reportType' => AmazonReportTypeEnum::class,
        'dataStartTime' => 'datetime',
        'dataEndTime' => 'datetime',
        'options' => 'array',
        'marketplaceIds' => 'array',
    ];

    protected $guarded = [];

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function integrationInstance(): BelongsTo
    {
        return $this->belongsTo(AmazonIntegrationInstance::class);
    }

    public function requestedByUser(): BelongsTo
    {
        return $this->belongsTo(User::class, 'requested_by_user_id');
    }

    /*
    |--------------------------------------------------------------------------
    | Implementers
    |--------------------------------------------------------------------------
    */

    public static function newFactory(): Factory
    {
        return AmazonReportRequestFactory::new();
    }
}
