<?php

namespace Modules\Amazon\Entities;

use App\DataTable\DataTableModelInterface;
use App\DataTable\DataTableModelTrait;
use App\Models\Concerns\Archive;
use App\Models\Concerns\HasFilters;
use App\Models\Concerns\HasSort;
use App\Models\InventoryAdjustment;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\Pivot;
use Modules\Amazon\Enums\Entities\AmazonLedgerSummaryAdjustmentTypeEnum;
use Throwable;

/**
 * @property int $id
 * @property int $amazon_fba_report_inventory_ledger_summary_id
 * @property int $inventory_adjustment_id
 * @property AmazonLedgerSummaryAdjustmentTypeEnum $type
 *
 * @property string $created_at
 * @property string $updated_at
 *
 * @property AmazonFbaReportInventoryLedgerSummary $amazonFbaReportInventoryLedgerSummary
 * @property InventoryAdjustment $inventoryAdjustment
 *
 */
class AmazonLedgerSummaryAdjustment extends Pivot implements DataTableModelInterface
{
    #use Archive;
    use DataTableModelTrait;
    use HasFactory;
    use HasFilters;
    use HasSort;

    protected $table = 'amazon_ledger_summary_adjustments';

    protected $guarded = [];

    protected $casts = [
        'type' => AmazonLedgerSummaryAdjustmentTypeEnum::class,
    ];

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function amazonFbaReportInventoryLedgerSummary(): BelongsTo
    {
        return $this->belongsTo(AmazonFbaReportInventoryLedgerSummary::class);
    }

    public function inventoryAdjustment(): BelongsTo
    {
        return $this->belongsTo(InventoryAdjustment::class);
    }

    /*
    |--------------------------------------------------------------------------
    | Other
    |--------------------------------------------------------------------------
    */

    public static function specialLabels(): array
    {
        return [
            'id' => 'ID',
            'fnsku' => 'FNSKU',
            'asin' => 'ASIN',
            'msku' => 'MSKU',
        ];
    }

    public function availableColumns(): array
    {
        return [
            'id' => 'int',
            'adjustment_date' => 'date/time',
            'fnsku' => 'string',
            'quantity' => 'int',
            'product' => 'product',
            'notes' => 'string',
            'asin' => 'string',
            'msku' => 'string',
            'created_at' => 'timestamp',
            'updated_at' => 'timestamp'
        ];
    }

    public function visibleColumns(): array
    {
        return [
            'id',
            'adjustment_date',
            'fnsku',
            'quantity',
            'product',
            'notes',
            'asin',
            'msku',
            'created_at',
            'updated_at'
        ];
    }

    /**
     * @throws Throwable
     */
    public function delete(): bool
    {
        $this->inventoryAdjustment->delete();
        return parent::delete();
    }
}
