<?php

namespace Modules\Amazon\Entities;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Illuminate\Database\Eloquent\Relations\Pivot;

/**
 * @property int $id
 * @property int $amazon_fba_report_inventory_ledger_id
 * @property int $detail_id
 * @property string $detail_type
 * @property string $created_at
 * @property string $updated_at
 *
 * @property AmazonFbaReportInventoryLedger $amazonFbaReportInventoryLedger
 * @property AbstractAmazonFbaDetailReport $detail
 *
 */
class AmazonLedgerDetail extends Pivot
{
    use HasFactory;

    protected $table = 'amazon_ledger_details';

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function amazonFbaReportInventoryLedger(): BelongsTo
    {
        return $this->belongsTo(AmazonFbaReportInventoryLedger::class);
    }

    public function detail(): MorphTo
    {
        return $this->morphTo('detail');
    }
}
