<?php

namespace Modules\Amazon\Entities;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

/**
 * @property int $id
 * @property int $amazon_fulfillment_shipment_id
 * @property-read string $sellerSku
 * @property-read string $sellerFulfillmentOrderItemId
 * @property-read int $quantity
 * @property-read int $packageNumber
 * @property-read string $serialNumber
 * @property array $json_object
 * @property-read AmazonFulfillmentShipment $amazonFulfillmentShipment
 * @property Carbon $created_at
 * @property ?Carbon $updated_at
 *
 * @mixin IdeHelperAmazonFulfillmentShipmentItem
 */
class AmazonFulfillmentShipmentItem extends Model
{
    protected $guarded = [];

    protected $casts = [
        'json_object' => 'array',
    ];

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function amazonFulfillmentShipment(): BelongsTo
    {
        return $this->belongsTo(AmazonFulfillmentShipment::class);
    }

    public function amazonFulfillmentReturnItems(): HasMany
    {
        return $this->hasMany(AmazonFulfillmentReturnItem::class);
    }
}
