<?php

namespace Modules\Amazon\Entities;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

/**
 * @property int $id
 * @property int $amazon_fulfillment_order_id
 * @property-read string $amazonShipmentId
 * @property-read string $fulfillmentCenterId
 * @property-read string $fulfillmentShipmentStatus
 * @property-read string $shippingDate
 * @property-read string $estimatedArrivalDate
 * @property-read string $shippingNotes
 * @property array $json_object
 * @property-read AmazonFulfillmentOrder $amazonFulfillmentOrder
 * @property-read AmazonFulfillmentShipmentItem[] $amazonFulfillmentShipmentItems
 * @property-read AmazonFulfillmentShipmentPackage[] $amazonFulfillmentShipmentPackages
 * @property Carbon $created_at
 * @property ?Carbon $updated_at
 *
 * @mixin IdeHelperAmazonFulfillmentShipment
 */
class AmazonFulfillmentShipment extends Model
{
    protected $guarded = [];

    protected $casts = [
        'json_object' => 'array',
    ];

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function amazonFulfillmentOrder(): BelongsTo
    {
        return $this->belongsTo(AmazonFulfillmentOrder::class);
    }

    public function amazonFulfillmentShipmentItems(): HasMany
    {
        return $this->hasMany(AmazonFulfillmentShipmentItem::class);
    }

    public function amazonFulfillmentShipmentPackages(): HasMany
    {
        return $this->hasMany(AmazonFulfillmentShipmentPackage::class);
    }
}
