<?php

namespace Modules\Amazon\Entities;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * @property int $id
 * @property int $amazon_fulfillment_shipment_item_id
 * @property-read string $sellerReturnId
 * @property-read string $sellerFulfillmentOrderItemId
 * @property-read string $amazonShipmentId
 * @property-read string $sellerReturnReasonCode
 * @property-read string $returnComment
 * @property-read string $amazonReturnReasonCode
 * @property-read string $status
 * @property-read string $statusChangedDate
 * @property-read string $returnAuthorizationId
 * @property-read string $returnReceivedCondition
 * @property-read string $fulfillmentCenterId
 * @property array $json_object
 * @property-read AmazonFulfillmentShipmentItem $amazonFulfillmentShipmentItem
 * @property Carbon $created_at
 * @property ?Carbon $updated_at
 *
 * @mixin IdeHelperAmazonFulfillmentReturnItem
 */
class AmazonFulfillmentReturnItem extends Model
{
    protected $guarded = [];

    protected $casts = [
        'json_object' => 'array',
    ];

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function amazonFulfillmentShipmentItem(): BelongsTo
    {
        return $this->belongsTo(AmazonFulfillmentShipmentItem::class);
    }
}
