<?php

namespace Modules\Amazon\Entities;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * @property int $id
 * @property int $amazon_fulfillment_order_id
 * @property-read string $returnAuthorizationId
 * @property-read string $fulfillmentCenterId
 * @property-read array $returnToAddress
 * @property-read string $amazonRmaId
 * @property-read string $rmaPageURL
 * @property array $json_object
 * @property-read AmazonFulfillmentOrder $amazonFulfillmentOrder
 * @property Carbon $created_at
 * @property ?Carbon $updated_at
 *
 * @mixin IdeHelperAmazonFulfillmentReturnAuthorization
 */
class AmazonFulfillmentReturnAuthorization extends Model
{
    protected $guarded = [];

    protected $casts = [
        'json_object' => 'array',
    ];

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function amazonFulfillmentOrder(): BelongsTo
    {
        return $this->belongsTo(AmazonFulfillmentOrder::class);
    }
}
