<?php

namespace Modules\Amazon\Entities;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Modules\Amazon\Database\Factories\AmazonFulfillmentOrderItemFactory;

/**
 * @property int $id
 * @property int $amazon_fulfillment_order_id
 * @property string $sellerSku
 * @property string $sellerFulfillmentOrderItemId
 * @property int $quantity
 * @property string $giftMessage
 * @property string $displayableComment
 * @property string $fulfillmentNetworkSku
 * @property-read string $orderItemDisposition
 * @property-read int $cancelledQuantity
 * @property-read int $unfulfillableQuantity
 * @property-read string $estimatedShipDate
 * @property-read string $estimatedArrivalDate
 * @property string $perUnitPriceCurrencyCode
 * @property float $perUnitPriceCurrencyValue
 * @property string $perUnitTaxCurrencyCode
 * @property float $perUnitTaxValue
 * @property string $perUnitDeclaredValueCurrencyCode
 * @property float $perUnitDeclaredValueValue
 * @property array $json_object
 * @property-read AmazonFulfillmentOrder $amazonFulfillmentOrder
 * @property Carbon $created_at
 * @property ?Carbon $updated_at
 *
 * @mixin IdeHelperAmazonFulfillmentOrderItem
 */
class AmazonFulfillmentOrderItem extends Model
{
    use HasFactory;

    protected $guarded = [];

    protected $casts = [
        'json_object' => 'array',
    ];

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function amazonFulfillmentOrder(): BelongsTo
    {
        return $this->belongsTo(AmazonFulfillmentOrder::class);
    }

    public static function newFactory()
    {
        return AmazonFulfillmentOrderItemFactory::new();
    }
}
