<?php

namespace Modules\Amazon\Entities;

use App\Models\IntegrationInstance;
use App\Models\NominalCode;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Modules\Amazon\Database\Factories\AmazonFinancialEventTypeNominalCodeMappingFactory;

/**
 * Class AmazonOrder.
 *
 * @property int $id
 * @property string $name
 * @property int $integration_instance_id
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property-read AmazonIntegrationInstance $integrationInstance
 * @property-read NominalCode $nominalCode
 */
class AmazonFinancialEventTypeNominalCodeMapping extends Model
{
    use HasFactory;

    protected $table = 'amazon_financial_event_type_nominal_code_mappings';

    protected $casts = [
        'id' => 'integer',
        'name' => 'string',
        'integration_instance_id' => 'integer',
        'nominal_code_id' => 'integer',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    protected $fillable = [
        'integration_instance_id',
        'name',
        'nominal_code_id',
    ];

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function integrationInstance(): BelongsTo
    {
        return $this->belongsTo(IntegrationInstance::class);
    }

    public function amazonIntegrationInstance(): BelongsTo
    {
        return $this->integrationInstance();
    }

    public function nominalCode(): BelongsTo
    {
        return $this->belongsTo(NominalCode::class);
    }

    /*
    |--------------------------------------------------------------------------
    | Factory
    |--------------------------------------------------------------------------
    */

    /**
     * @return Factory<static>
     */
    public static function newFactory(): Factory
    {
        return AmazonFinancialEventTypeNominalCodeMappingFactory::new();
    }
}
