<?php

namespace Modules\Amazon\Entities;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Carbon;

/**
 * @property int $id
 * @property int $integration_instance_id
 * @property string $checksum
 * @property-read string $AdjustmentType
 * @property-read string $PostedDate
 * @property-read float $CurrencyAmount
 * @property-read string $CurrencyCode
 * @property-read AmazonIntegrationInstance $integrationInstance
 * @property array $json_object
 * @property Carbon $created_at
 * @property ?Carbon $updated_at
 */
class AmazonFinancialAdjustmentEvent extends AmazonFinancialEvent
{
    protected $casts = [
        'json_object' => 'array',
        'AdjustmentType' => 'string',
        'PostedDate' => 'string',
        'CurrencyAmount' => 'float',
        'CurrencyCode' => 'string',
    ];

    protected $fillable = [
        'integration_instance_id',
        'amazon_financial_event_group_id',
        'json_object',
    ];

    public static function getUniqueId(): string
    {
        return 'checksum';
    }

    public static function getTableUniqueId(): string
    {
        return 'checksum';
    }

    public static function getIntegrationName(): string
    {
        return 'amazon';
    }

    /*
    |--------------------------------------------------------------------------
    | Relationships
    |--------------------------------------------------------------------------
    */

    public function integrationInstance(): BelongsTo
    {
        return $this->belongsTo(AmazonIntegrationInstance::class);
    }

    /**
     * @return Factory<static>
     */
    public static function newFactory(): Factory
    {
        return AmazonFinancialShipmentEvent::new();
    }
}
