<?php

namespace Modules\Amazon\Entities;

use App\DataTable\DataTableModelInterface;
use App\DataTable\DataTableModelTrait;
use App\Models\Concerns\BulkImport;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * @property int $id
 * @property int $integration_instance_id
 * @property-read string $country
 * @property-read string $product_name
 * @property-read string $fnsku
 * @property-read string $merchant_sku
 * @property-read string $asin
 * @property-read string $condition
 * @property-read string $supplier
 * @property-read string $supplier_part_no
 * @property-read string $currency_code
 * @property-read float $price
 * @property-read float $sales_last_30_days
 * @property-read int $units_sold_last_30_days
 * @property-read int $total_units
 * @property-read int $inbound
 * @property-read int $available
 * @property-read int $fc_transfer
 * @property-read int $fc_processing
 * @property-read int $customer_order
 * @property-read int $unfulfillable
 * @property-read int $working
 * @property-read int $shipped
 * @property-read int $receiving
 * @property-read string $fulfilled_by
 * @property-read string $total_days_of_supply
 * @property-read string $days_of_supply_at_amazon_fulfillment_network
 * @property-read string $alert
 * @property-read int $recommended_replenishment_qty
 * @property-read string $recommended_ship_date
 * @property array $json_object
 * @property-read AmazonIntegrationInstance $integrationInstance
 * @property Carbon $created_at
 * @property null|Carbon $updated_at
 *
 * @mixin IdeHelperAmazonFbaReportRestock
 */
class AmazonFbaReportRestock extends AbstractAmazonReport implements DataTableModelInterface
{
    use DataTableModelTrait;

    protected $table = 'amazon_fba_report_restock';

    protected $guarded = [];

    protected $casts = [
        'json_object' => 'array',
    ];

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function integrationInstance(): BelongsTo
    {
        return $this->belongsTo(AmazonIntegrationInstance::class, 'integration_instance_id');
    }

    /*
    |--------------------------------------------------------------------------
    | Overrides
    |--------------------------------------------------------------------------
    */

    public static function specialLabels(): array
    {
        return [
            'id' => 'ID',
            'fnsku' => 'FNSKU',
            'merchant_sku' => 'Merchant SKU',
            'asin' => 'ASIN',
        ];
    }

    public function availableColumns(): array
    {
        $this->availableColumns = [
            'id' => 'bigint',
            'recommended_replenishment_qty' => 'int',
            'recommended_ship_date' => 'string',
            'product_name' => 'string',
            'merchant_sku' => 'string',
            'fnsku' => 'string',
            'asin' => 'string',
            'country' => 'string',
            'condition' => 'string',
            'supplier' => 'string',
            'supplier_part_no' => 'string',
            'currency_code' => 'string',
            'price' => 'float',
            'sales_last_30_days' => 'float',
            'units_sold_last_30_days' => 'int',
            'total_units' => 'int',
            'inbound' => 'int',
            'available' => 'int',
            'fc_transfer' => 'int',
            'fc_processing' => 'int',
            'customer_order' => 'int',
            'unfulfillable' => 'int',
            'working' => 'int',
            'shipped' => 'int',
            'receiving' => 'int',
            'fulfilled_by' => 'string',
            'total_days_of_supply' => 'string',
            'days_of_supply_at_amazon_fulfillment_network' => 'string',
            'alert' => 'string',
            'created_at' => 'datetime',
            'updated_at' => 'datetime',
        ];
        return $this->availableColumns;
    }

    public function visibleColumns(): array
    {
        return [
            'id',
            'country',
            'fnsku',
            'merchant_sku',
            'asin',
            'product_name',
            'condition',
            'sales_last_30_days',
            'units_sold_last_30_days',
            'total_units',
            'inbound',
            'available',
            'fc_transfer',
            'fc_processing',
            'customer_order',
            'unfulfillable',
            'working',
            'shipped',
            'receiving',
            'fulfilled_by',
            'total_days_of_supply',
            'days_of_supply_at_amazon_fulfillment_network',
            'alert',
            'recommended_replenishment_qty',
            'recommended_ship_date',
        ];
    }
}
