<?php

// TODO: Complete this model according to specs in SKU-5455

namespace Modules\Amazon\Entities;

use App\DataTable\DataTableModelInterface;
use App\DataTable\DataTableModelTrait;
use App\Models\Concerns\BulkImport;
use App\Models\Concerns\HasFilters;
use App\Models\Concerns\HasSort;
use App\Models\Contracts\Filterable;
use App\Models\Contracts\Sortable;
use App\Models\FifoLayer;
use App\Models\WarehouseTransferShipmentLine;
use Awobaz\Compoships\Compoships;
use Carbon\Carbon;
use Exception;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * @property int $id
 * @property int $integration_instance_id
 * @property ?null $amazon_product_id
 * @property ?null $fifo_layer_id
 * @property Carbon $sku_product_initialized_at
 * @property array $json_object
 * @property string $date
 * @property string $fnsku
 * @property string $asin
 * @property string $msku
 * @property string $title
 * @property string $disposition
 * @property int $starting_warehouse_balance
 * @property int $in_transit_between_warehouses
 * @property int $receipts
 * @property int $customer_shipments
 * @property int $customer_returns
 * @property int $vendor_returns
 * @property int $warehouse_transfer_in_out
 * @property int $found
 * @property int $lost
 * @property int $damaged
 * @property int $disposed
 * @property int $other_events
 * @property int $ending_warehouse_balance
 * @property int $total_inventory_quantity
 * @property int $unknown_events
 * @property string $location
 * @property-read AmazonIntegrationInstance $integrationInstance
 * @property-read AmazonReport $amazonReport
 * @property-read FifoLayer $fifoLayer
 * @property-read AmazonFnskuProduct $amazonFnskuProduct
 * @property Carbon $created_at
 * @property ?Carbon $updated_at
 */
class AmazonFbaInitialInventory extends AbstractAmazonReport implements Filterable, Sortable, DataTableModelInterface
{
    use BulkImport,
        Compoships,
        DataTableModelTrait,
        HasFactory,
        HasFilters,
        HasSort;

    protected $table = 'amazon_fba_initial_inventory';

    protected $guarded = [];

    protected $casts = [
        'json_object' => 'array',
    ];

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    /**
     * @throws Exception
     */
    public function amazonReport(): BelongsTo
    {
        return $this->belongsTo(AmazonReport::class);
    }

    public function fifoLayer(): BelongsTo
    {
        return $this->belongsTo(FifoLayer::class);
    }

    public function amazonFnskuProduct(): BelongsTo
    {
        return $this->belongsTo(AmazonFnskuProduct::class, [
            'integration_instance_id',
            'fnsku',
            'location',
            'disposition'
        ],
        [
            'integration_instance_id',
            'fnsku',
            'location',
            'disposition'
        ]);
    }

    /*
    |--------------------------------------------------------------------------
    | Implementers for Filterable
    |--------------------------------------------------------------------------
    */

    public function visibleColumns(): array
    {
        return [
            'id',
            'fnsku',
            'location',
            'disposition',
            'fifo_layer_id',
            'sku_product_initialized_at',
            'in_transit_between_warehouses',
            'ending_warehouse_balance',
            'total_inventory_quantity',
        ];
    }

    public function generalFilterableColumns(): array
    {
        return ['msku', 'fnsku', 'asin', 'title'];
    }

    /*
    |--------------------------------------------------------------------------
    | Implementers for Sortable
    |--------------------------------------------------------------------------
    */

    public function sortableColumns(): array
    {
        return collect($this->availableColumns())->where('sortable', 1)->pluck('data_name')->all();
    }

    /*
    |--------------------------------------------------------------------------
    | Scopes
    |--------------------------------------------------------------------------
    */

    public function scopeFnskuSort(Builder $builder): Builder
    {
        return $builder->orderBy('fnsku')
            ->orderBy('disposition')
            ->orderBy('location');
    }
}
