<?php

namespace Modules\Amazon\Entities;

use App\Abstractions\UniqueFieldsInterface;
use Awobaz\Compoships\Compoships;
use Awobaz\Compoships\Database\Eloquent\Relations\HasMany;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Modules\Amazon\Abstractions\AmazonFbaInboundFromInterface;

/**
 * @property int $id
 * @property int $integration_instance_id
 * @property string $name
 * @property int $link_id
 * @property string $link_type
 * @property Carbon $created_at
 * @property ?Carbon $updated_at
 *
 * @property-read AmazonIntegrationInstance $integrationInstance
 * @property-read AmazonFbaInboundFromInterface $link
 * @property-read AmazonFbaInboundShipment[] $amazonFbaInboundShipments
 */
class AmazonFbaInboundShipFromMapping extends Model implements UniqueFieldsInterface
{
    use HasFactory;
    use Compoships;

    public static function getUniqueFields(): array
    {
        return ['integration_instance_id', 'name'];
    }


    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function integrationInstance(): BelongsTo
    {
        return $this->belongsTo(AmazonIntegrationInstance::class);
    }

    public function link(): MorphTo
    {
        return $this->morphTo();
    }

    public function amazonFbaInboundShipments(): HasMany
    {
        return $this->hasMany(AmazonFbaInboundShipment::class,
            ['integration_instance_id', 'ShipFromName'],
            ['integration_instance_id', 'name']
        );
    }
}
