<?php

namespace Modules\Amazon\Entities;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasOneThrough;

abstract class AbstractAmazonFbaDetailReport extends AbstractAmazonReport implements AmazonFbaDetailReportInterface
{
    use HasFactory;

    protected $guarded = [];

    protected $casts = [
        'json_object' => 'array',
    ];

    abstract public function getDateField(): string;

    abstract public static function getQuantityField(): string;

    abstract public static function hasNegativeLedgerImpact(): bool;

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function ledger(): HasOneThrough
    {
        return $this->hasOneThrough(
            AmazonFbaReportInventoryLedger::class,
            AmazonLedgerDetail::class,
            'detail_id', // Foreign key on AmazonLedgerDetail table
            'id', // Foreign key on AmazonFbaReportInventoryLedger table
            'id', // Local key on this model
            'amazon_fba_report_inventory_ledger_id' // Local key on AmazonLedgerDetail table
        )->where('detail_type', '=', static::class);
    }
}
