<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('amazon_financial_charge_instruments', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('parent_id');
            $table->string('parent_type');
            $table->string('Description')->storedAs('json_extract(json_object, "$.Description")');
            $table->string('Tail')->storedAs('json_extract(json_object, "$.Tail")');
            $table->decimal('CurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.Amount.CurrencyAmount")');
            $table->string('CurrencyCode')->storedAs('json_extract(json_object, "$.Amount.CurrencyCode")');
            $table->json('json_object');
            $table->timestamps();
            $table->index(['parent_id', 'parent_type'], 'parent_index');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_financial_charge_instruments');
    }
};
